$(document).ready(function () {
    const fullUrl = window.location.href;
    function getDeviceType() {
        const userAgent = navigator.userAgent.toLowerCase() || navigator.vendor || window.opera;
        if (Boolean(userAgent.match(/android|mobile|pad/i) && Boolean(userAgent.match(/ipad/i)) === false && Boolean(userAgent.match(/mac/i)) === false)) {
            return 'Android';
        }
        if (Boolean(userAgent.match(/iphone/i))) {
            return 'iOS';
        }
        if (Boolean(userAgent.match(/ipad|pad/i))) {
            return 'pad';
        }
        if (Boolean(userAgent.match(/mobile|android|iphone/i)) === false) {
            return 'PC'
        }
        return 'Unknown';
    }

    const deviceType = getDeviceType();
    const fullUrlstr = fullUrl.replace("code=", "codetemp=");

    function selectDownload(data) {
        $("#iphone, #iphoneWeb").on("click", function (e) {
            e.preventDefault();
            const modal = $('<div class="download-modal">')
                .css({
                    position: 'fixed',
                    top: 0,
                    left: 0,
                    right: 0,
                    bottom: 0,
                    backgroundColor: 'rgba(0,0,0,0.5)',
                    display: 'flex',
                    justifyContent: 'center',
                    alignItems: 'center',  // Changed from center to flex-end
                    zIndex: 1000
                })
                .append(
                    $('<div class="download-options">')
                        .css({
                            padding: '20px',
                            borderRadius: '8px',
                            display: 'flex',
                            flexDirection: 'column',
                            gap: '10px',
                            textAlign: 'center',
                            width: '80%'
                        })
                        .append(
                            $('<button>')
                                .text('商店下载（App Store）')
                                .css({
                                    width: '90%',
                                    margin: '0 auto',
                                    padding: '12px',
                                    borderRadius: '6px',
                                    backgroundColor: '#fff',

                                })
                                .on('click', function () {
                                    window.location.href = data.store_url;
                                }),
                            $('<button>')
                                .text('直接安装到桌面')
                                .css({
                                    width: '90%',
                                    margin: '0 auto',
                                    padding: '12px',
                                    borderRadius: '6px',
                                    backgroundColor: '#fff',

                                })
                                .on('click', function () {
                                    window.location.href = data.pwaUrl;
                                })
                        )
                );

            $('body').append(modal);

            modal.on('click', function (e) {
                if (e.target === this) {
                    modal.remove();
                }
            });
        });
    }

    let params = {};
    fetch(`/index.php?mod=index&code=config&url=${encodeURIComponent(fullUrl)}`, { method: "GET" })
        .then((response) => response.json())
        .then((result) => {
            const data = result.data;
            $(".spinner-container").remove();
            $("#group").attr({ href: data.user_tg_url });
            $("#business").attr({ href: data.tg_url });
             if(data.store_url != ""){
                selectDownload(data);
            }else{
                $('#iphone').attr({ href:  data.pwaUrl });
                $('#iphoneWeb').attr({ href: data.pwaUrl });
            }
            $('#androidWeb').attr({ href: data.androidURL, 'data-clipboard-text': data.share });
            $('#android').attr({ href: data.androidURL, 'data-clipboard-text': data.share });
            $('#android2').attr({ href: data.androidmaskURL, 'data-clipboard-text': data.share });

            new ClipboardJS(".clipboard-btn");

            params = data;
        })
        .catch(() => {
            $(".spinner-container").remove();
        });

    if (deviceType == 'PC' || deviceType == "Unknown" || deviceType == 'pad' ) {
        $(".qr").each(function () {
            $(this).qrcode({
                correctLevel: 1,
                text: location.href,
            });
        });
    }

    $("#android,#andriod2").on('click', function () {
        $('#platform-list').fadeIn().css('display', 'flex');
    });

    $('.setup-tips').on('click', function () {
        if (deviceType == "Android") {
            $('#platform-list').fadeIn().css('display', 'flex');
        }
        if (deviceType == "iOS") {
            $('#ios-detail').fadeIn().css('display', 'flex');
        }
    });

    $('.platform-item').on('click', function () {
        const imgSrc = $(this).data('src');
        const imgSrc2 = $(this).data('src2');
        const platformDetail = $('#platform-detail')
        platformDetail.find('.modal-common-img').attr('src', imgSrc)
        if (imgSrc2 !== "" || imgSrc2 !== undefined) {
            platformDetail.find('.modal-common-img-2').attr('src', imgSrc2)
        }
        platformDetail.fadeIn().css('display', 'flex');
    });

    $('.android-modal-arrow').on('click', function () {
        const type = $(this).data('type')
        if (type === 1) {
            $('#platform-list').fadeOut()
        }
        if (type === 2) {
            $('#platform-detail').fadeOut();
            const platformDetail = $('#platform-detail');
            platformDetail.find('.modal-common-img').attr('src', '');
            platformDetail.find('.modal-common-img-2').attr('src', '')
        }
        if (type === 3) {
            $('#ios-detail').fadeOut();
        }
    });

    function onAnroidStat() {
        const parsedUrl = new URL(fullUrl);
        fetch(`/index.php?mod=index&code=stat`)
    }

    $("#android, #android2").on('click', function () {
        $('#platform-list').fadeIn().css('display', 'flex');
        onAnroidStat();
    });

});
